/*
 * Decompiled with CFR 0.152.
 */
package forge.net.nimajnebec.autoelytra.feature;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AutoEquipController {
    private static final NbtPathArgument.NbtPath[] BLACKLISTED_TAGS = AutoEquipController.parseTagPaths("tag.Damage");
    @Nullable
    private static CompoundTag previousChestTag;

    public static void setPreviousChestItem(ItemStack item) {
        if (!item.m_41619_()) {
            previousChestTag = AutoEquipController.getFilteredTag(item);
        }
    }

    public static boolean hasPreviousChestItem() {
        return previousChestTag != null;
    }

    public static void resetPreviousChestItem() {
        previousChestTag = null;
    }

    public static boolean matchesPreviousChestItem(ItemStack item) {
        return !item.m_41619_() && AutoEquipController.getFilteredTag(item).equals((Object)previousChestTag);
    }

    private static CompoundTag getFilteredTag(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41739_(new CompoundTag());
        for (NbtPathArgument.NbtPath path : BLACKLISTED_TAGS) {
            path.m_99648_((Tag)tag);
        }
        return tag;
    }

    private static NbtPathArgument.NbtPath[] parseTagPaths(String ... args) {
        NbtPathArgument.NbtPath[] result = new NbtPathArgument.NbtPath[args.length];
        for (int i = 0; i < args.length; ++i) {
            try {
                result[i] = NbtPathArgument.m_99487_().parse(new StringReader(args[i]));
                continue;
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

